"use client"

import { Star } from "lucide-react"

interface RecommendedItem {
  name: string
  price: string
  category: string
  reason: string
}

interface RecommendedItemsProps {
  items: RecommendedItem[]
}

export function RecommendedItems({ items }: RecommendedItemsProps) {
  return (
    <section className="mb-16 md:mb-24">
      <div className="flex items-center justify-center gap-3 md:gap-4 mb-8 md:mb-12">
        <div className="h-px bg-accent/30 flex-1 max-w-[100px] md:max-w-xs" />
        <div className="flex items-center gap-2">
          <Star className="w-6 h-6 md:w-8 md:h-8 text-accent fill-accent" />
          <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-center text-balance">
            Chef's Recommendations
          </h2>
          <Star className="w-6 h-6 md:w-8 md:h-8 text-accent fill-accent" />
        </div>
        <div className="h-px bg-accent/30 flex-1 max-w-[100px] md:max-w-xs" />
      </div>

      <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6">
        {items.map((item, index) => (
          <div
            key={index}
            className="relative group bg-gradient-to-br from-accent/10 to-accent/5 border border-accent/30 rounded-lg p-4 md:p-6 hover:border-accent/60 transition-all duration-300 hover:shadow-lg hover:shadow-accent/20"
          >
            <div className="absolute -top-3 -right-3 bg-accent text-primary rounded-full p-2 shadow-lg">
              <Star className="w-4 h-4 fill-current" />
            </div>

            <div className="space-y-3">
              <div>
                <h3 className="text-lg sm:text-xl font-semibold text-foreground group-hover:text-accent transition-colors">
                  {item.name}
                </h3>
                <p className="text-xs sm:text-sm text-muted-foreground mt-1">{item.category}</p>
              </div>

              <p className="text-sm text-muted-foreground italic leading-relaxed">{item.reason}</p>

              <div className="flex items-center justify-between pt-2 border-t border-accent/20">
                <span className="text-sm font-medium text-muted-foreground">Price</span>
                <span className="text-lg font-bold text-accent">₦{item.price}</span>
              </div>
            </div>
          </div>
        ))}
      </div>
    </section>
  )
}
