import { Star } from "react-feather" // Import the Star component

interface MenuItem {
  name: string
  price: string
  description?: string
  recommended?: boolean
}

interface MenuSectionProps {
  title: string
  items: MenuItem[]
}

export function MenuSection({ title, items }: MenuSectionProps) {
  return (
    <div className="space-y-4 md:space-y-6">
      <div className="relative">
        <div className="absolute inset-0 bg-gradient-to-r from-accent/5 to-transparent rounded-lg -z-10" />
        <h3 className="text-xl sm:text-2xl md:text-3xl font-semibold text-accent px-4 md:px-6 py-3 md:py-4 border-l-2 border-accent tracking-wide">
          {title}
        </h3>
      </div>

      <div className="space-y-2 md:space-y-3 pl-1 md:pl-2">
        {items.map((item, index) => (
          <div
            key={index}
            className={`flex justify-between items-start gap-3 md:gap-4 group py-2 md:py-3 px-3 md:px-4 rounded-lg transition-all duration-300 border ${
              item.recommended
                ? "bg-accent/10 border-accent/40 hover:bg-accent/15 hover:border-accent/60"
                : "border-transparent hover:bg-accent/5 hover:border-accent/20"
            }`}
          >
            <div className="flex-1 min-w-0">
              <div className="flex items-center gap-2">
                <h4 className="font-medium text-sm sm:text-base md:text-lg leading-relaxed text-foreground group-hover:text-accent transition-colors break-words">
                  {item.name}
                </h4>
                {item.recommended && (
                  <span className="inline-flex items-center gap-1 px-2 py-1 bg-accent/20 text-accent text-xs font-semibold rounded-full whitespace-nowrap">
                    <Star className="w-3 h-3 fill-current" />
                    Recommended
                  </span>
                )}
              </div>
              {item.description && (
                <p className="text-xs sm:text-sm text-muted-foreground mt-1 italic leading-relaxed">
                  {item.description}
                </p>
              )}
            </div>
            <div className="text-right flex-shrink-0">
              <span className="font-semibold text-sm sm:text-base md:text-lg whitespace-nowrap text-accent">
                ₦{item.price}
              </span>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}
