import { MapPin, Phone, Mail, Clock } from "lucide-react"

export function MenuFooter() {
  return (
    <footer className="relative bg-primary text-primary-foreground py-8 md:py-12 overflow-hidden">
      <div className="container mx-auto px-4 relative z-10">
        <div className="text-center border-b border-accent/20 pb-6 mb-6">
          <h2 className="text-lg sm:text-xl md:text-2xl font-bold mb-1">Thanks for Your Patronage</h2>
          <p className="text-primary-foreground/80 text-xs sm:text-sm">We look forward to serving you again</p>
        </div>

        <div className="text-center mb-6">
          <div className="flex flex-wrap items-center justify-center gap-4 sm:gap-6 text-xs sm:text-sm text-primary-foreground/80">
            <a
              href="https://maps.google.com/?q=50B+Country+Home+Road+GRA+Benin+City"
              target="_blank"
              rel="noopener noreferrer"
              className="hover:text-accent transition-colors flex items-center gap-1"
            >
              <MapPin className="w-4 h-4" />
              <span>50B Country Home Road, Benin City</span>
            </a>
            <span className="hidden sm:inline text-accent/40">•</span>
            <a href="tel:+2348057969991" className="hover:text-accent transition-colors flex items-center gap-1">
              <Phone className="w-4 h-4" />
              <span>+234 805 796 9991</span>
            </a>
            <span className="hidden sm:inline text-accent/40">•</span>
            <a
              href="mailto:contact@dpluglounge.ng"
              className="hover:text-accent transition-colors flex items-center gap-1"
            >
              <Mail className="w-4 h-4" />
              <span>contact@dpluglounge.ng</span>
            </a>
          </div>
          <div className="flex items-center justify-center gap-1 text-xs sm:text-sm text-primary-foreground/80 mt-3">
            <Clock className="w-4 h-4" />
            <span>Mon - Sun: 8am - 3am</span>
          </div>
        </div>

        <div className="text-center border-t border-accent/20 pt-6">
          <p className="text-xs sm:text-sm text-primary-foreground/70 mb-2">
            POWERED BY{" "}
            <a
              href="https://link.omarconsults.ng/dplugmenu"
              target="_blank"
              rel="noopener noreferrer"
              className="text-accent hover:text-accent/80 transition-colors font-semibold underline decoration-accent/30 hover:decoration-accent/60"
            >
              INNOVATION
            </a>
          </p>
          <p className="text-xs text-primary-foreground/60">
            &copy; {new Date().getFullYear()} D'Plug Lounge & Restaurant. All rights reserved.
          </p>
        </div>
      </div>
    </footer>
  )
}
